library ieee;
use ieee.std_logic_1164.all;

entity fir is
port (
  clk, reset : in std_logic;
  x_0 : in std_logic_vector(4 downto 0);
  y : out std_logic_vector(9 downto 0));
end fir;
architecture generated of fir is
component fir_pp
port (
clk, reset : in std_logic;
  in_0 : in std_logic_vector(4 downto 0);
  out_1_3 : out std_logic_vector(0 downto 0);
  out_1_4 : out std_logic_vector(2 downto 0);
  out_1_5 : out std_logic_vector(4 downto 0);
  out_1_6 : out std_logic_vector(6 downto 0);
  out_1_7 : out std_logic_vector(6 downto 0);
  out_1_8 : out std_logic_vector(5 downto 0);
  out_1_9 : out std_logic_vector(3 downto 0);
  out_1_10 : out std_logic_vector(1 downto 0));
end component;
component fir_cs
port (
  clk, reset : in std_logic;
  in_1_3 : in std_logic_vector(0 downto 0);
  in_1_4 : in std_logic_vector(2 downto 0);
  in_1_5 : in std_logic_vector(4 downto 0);
  in_1_6 : in std_logic_vector(6 downto 0);
  in_1_7 : in std_logic_vector(6 downto 0);
  in_1_8 : in std_logic_vector(5 downto 0);
  in_1_9 : in std_logic_vector(3 downto 0);
  in_1_10 : in std_logic_vector(1 downto 0);
  out_1 : out std_logic_vector(0 downto 0);
  out_2 : out std_logic_vector(1 downto 0);
  out_3 : out std_logic_vector(1 downto 0);
  out_4 : out std_logic_vector(1 downto 0);
  out_5 : out std_logic_vector(1 downto 0);
  out_6 : out std_logic_vector(1 downto 0);
  out_7 : out std_logic_vector(0 downto 0);
  out_8 : out std_logic_vector(0 downto 0);
  out_9 : out std_logic_vector(0 downto 0);
  out_10 : out std_logic_vector(0 downto 0));
end component;
component fir_vma
port (
  clk, reset : in std_logic;
  in_1_1 : in std_logic_vector(0 downto 0);
  in_1_2 : in std_logic_vector(1 downto 0);
  in_1_3 : in std_logic_vector(1 downto 0);
  in_1_4 : in std_logic_vector(1 downto 0);
  in_1_5 : in std_logic_vector(1 downto 0);
  in_1_6 : in std_logic_vector(1 downto 0);
  in_1_7 : in std_logic_vector(0 downto 0);
  in_1_8 : in std_logic_vector(0 downto 0);
  in_1_9 : in std_logic_vector(0 downto 0);
  in_1_10 : in std_logic_vector(0 downto 0);
  out_1 : out std_logic_vector(0 downto 0);
  out_2 : out std_logic_vector(0 downto 0);
  out_3 : out std_logic_vector(0 downto 0);
  out_4 : out std_logic_vector(0 downto 0);
  out_5 : out std_logic_vector(0 downto 0);
  out_6 : out std_logic_vector(0 downto 0);
  out_7 : out std_logic_vector(0 downto 0);
  out_8 : out std_logic_vector(0 downto 0);
  out_9 : out std_logic_vector(0 downto 0);
  out_10 : out std_logic_vector(0 downto 0));
end component;
signal pp_1_3 : std_logic_vector(0 downto 0);
signal pp_1_4 : std_logic_vector(2 downto 0);
signal pp_1_5 : std_logic_vector(4 downto 0);
signal pp_1_6 : std_logic_vector(6 downto 0);
signal pp_1_7 : std_logic_vector(6 downto 0);
signal pp_1_8 : std_logic_vector(5 downto 0);
signal pp_1_9 : std_logic_vector(3 downto 0);
signal pp_1_10 : std_logic_vector(1 downto 0);
signal cs_1 : std_logic_vector(0 downto 0);
signal cs_2 : std_logic_vector(1 downto 0);
signal cs_3 : std_logic_vector(1 downto 0);
signal cs_4 : std_logic_vector(1 downto 0);
signal cs_5 : std_logic_vector(1 downto 0);
signal cs_6 : std_logic_vector(1 downto 0);
signal cs_7 : std_logic_vector(0 downto 0);
signal cs_8 : std_logic_vector(0 downto 0);
signal cs_9 : std_logic_vector(0 downto 0);
signal cs_10 : std_logic_vector(0 downto 0);
begin
pp_i: fir_pp port map(
  clk => clk,
  reset => reset,
  in_0 => x_0,
  out_1_3 => pp_1_3,
  out_1_4 => pp_1_4,
  out_1_5 => pp_1_5,
  out_1_6 => pp_1_6,
  out_1_7 => pp_1_7,
  out_1_8 => pp_1_8,
  out_1_9 => pp_1_9,
  out_1_10 => pp_1_10);
cs_i: fir_cs port map(
  clk => clk,
  reset => reset,
  in_1_3 => pp_1_3,
  in_1_4 => pp_1_4,
  in_1_5 => pp_1_5,
  in_1_6 => pp_1_6,
  in_1_7 => pp_1_7,
  in_1_8 => pp_1_8,
  in_1_9 => pp_1_9,
  in_1_10 => pp_1_10,
  out_1 => cs_1,
  out_2 => cs_2,
  out_3 => cs_3,
  out_4 => cs_4,
  out_5 => cs_5,
  out_6 => cs_6,
  out_7 => cs_7,
  out_8 => cs_8,
  out_9 => cs_9,
  out_10 => cs_10);
vma_i: fir_vma port map(
  clk => clk,
  reset => reset,
  in_1_1 => cs_1,
  in_1_2 => cs_2,
  in_1_3 => cs_3,
  in_1_4 => cs_4,
  in_1_5 => cs_5,
  in_1_6 => cs_6,
  in_1_7 => cs_7,
  in_1_8 => cs_8,
  in_1_9 => cs_9,
  in_1_10 => cs_10,
  out_1(0) => y(9),
  out_2(0) => y(8),
  out_3(0) => y(7),
  out_4(0) => y(6),
  out_5(0) => y(5),
  out_6(0) => y(4),
  out_7(0) => y(3),
  out_8(0) => y(2),
  out_9(0) => y(1),
  out_10(0) => y(0));
end generated;
